/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.util.ui.TextTransferable;
import com.wd.yamlhelper.constant.FileTypes;
import com.wd.yamlhelper.util.JsonAssistantUtil;
import java.awt.datatransfer.Transferable;

public class PlatformUtil {
    private static final Logger LOG = Logger.getInstance(PlatformUtil.class);

    public static FileType getFileType(FileTypes fileTypes) {
        return PlatformUtil.getFileType(fileTypes, (FileType)PlainTextFileType.INSTANCE);
    }

    public static FileType getFileType(FileTypes fileTypes, FileType defaultFileType) {
        Object instance;
        Class<?> clz = JsonAssistantUtil.getClassByName(fileTypes.getFileTypeQualifiedName());
        if (clz != null && (instance = JsonAssistantUtil.readStaticFinalFieldValue(clz, fileTypes.getFileTypeInstanceFieldName())) instanceof FileType) {
            return (FileType)instance;
        }
        return defaultFileType;
    }

    public static void setClipboard(String content) {
        CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(content));
    }
}

