/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.jump;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;

public class JumpToLineUtil {
    public static void jumpToLine(AnActionEvent event, int lineNumber) {
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.exists()) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        FileEditor activeEditor = fileEditorManager.getSelectedEditor(virtualFile);
        if (activeEditor instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)activeEditor;
            Editor editor = textEditor.getEditor();
            int offset = editor.getDocument().getLineStartOffset(lineNumber);
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }
}

