/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ErrorStripeEditorCustomization;
import com.intellij.util.ui.JBUI;
import com.wd.yamlhelper.util.UIManagers;
import java.awt.Color;
import java.util.Objects;

public class MyEditorFactory {
    private Project project;

    public MyEditorFactory(Project project) {
        this.project = project;
    }

    public Editor createEditor(String fileName, FileType fileType, String text) {
        LightVirtualFile sourceVirtualFile = new LightVirtualFile(fileName, fileType, (CharSequence)text);
        PsiFile sourceFile = PsiManager.getInstance((Project)this.project).findFile((VirtualFile)sourceVirtualFile);
        Document doc = PsiDocumentManager.getInstance((Project)this.project).getDocument(sourceFile);
        Editor editor = EditorFactory.getInstance().createEditor(doc, this.project, (VirtualFile)sourceVirtualFile, false, EditorKind.MAIN_EDITOR);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setLineNumbersShown(true);
        editorSettings.setIndentGuidesShown(true);
        editorSettings.setFoldingOutlineShown(true);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setCaretRowShown(true);
        ErrorStripeEditorCustomization.DISABLED.customize((EditorEx)editor);
        Objects.requireNonNull(SpellCheckingEditorCustomizationProvider.getInstance().getDisabledCustomization()).customize((EditorEx)editor);
        EditorGutterComponentEx gutterComponentEx = ((EditorEx)editor).getGutterComponentEx();
        gutterComponentEx.setPaintBackground(false);
        editorSettings.setUseSoftWraps(true);
        return editor;
    }

    private void toggleColorSchema(EditorEx editor, EditorColorsScheme defaultColorsScheme) {
        Color newColor;
        Color oriColor = editor.getBackgroundColor();
        if (!Objects.equals(oriColor, newColor = defaultColorsScheme.getDefaultBackground())) {
            editor.setColorsScheme(defaultColorsScheme);
        }
        editor.getComponent().setBorder(JBUI.Borders.customLine((Color)editor.getBackgroundColor(), (int)0, (int)4, (int)0, (int)0));
        UIManagers.repaintEditor((Editor)editor);
    }
}

