/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.analyzer;

import cn.hutool.core.util.StrUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.wd.yamlhelper.analyzer.UIFormEditor;
import com.wd.yamlhelper.persistent.YamlPersistent;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class YmlFileEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String[] YML_ENDS = new String[]{".yml", ".yaml"};
    private static final Logger LOG = Logger.getInstance((String)"com.wd.yh.analyzer.YmlFileEditorProvider");
    private int lastLine = -1;

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(1);
        }
        return this.isYmlFile(project, file);
    }

    private boolean isYmlFile(Project project, VirtualFile file) {
        String name = file.getName();
        for (String ymlEnd : YML_ENDS) {
            if (!name.endsWith(ymlEnd)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public FileEditor createEditor(final @NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(3);
        }
        TextEditor textEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file);
        LOG.assertTrue(this.accept(project, file));
        UIFormEditor uiFormEditor = new UIFormEditor(project, file);
        TextEditorWithPreview yamlEditor = new TextEditorWithPreview(textEditor, (FileEditor)uiFormEditor, "YamlEditor");
        CaretListener caretListener = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.caretPositionChanged(event);
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument());
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                FileEditor activeEditor = fileEditorManager.getSelectedEditor(virtualFile);
                if (activeEditor instanceof TextEditorWithPreview) {
                    TextEditorWithPreview textEditorWithPreview = (TextEditorWithPreview)activeEditor;
                    Editor editor = textEditorWithPreview.getEditor();
                    UIFormEditor previewEditor = (UIFormEditor)textEditorWithPreview.getPreviewEditor();
                    int currentLine = Objects.requireNonNull(event.getCaret()).getLogicalPosition().line;
                    if (currentLine != YmlFileEditorProvider.this.lastLine) {
                        YmlFileEditorProvider.this.lastLine = currentLine;
                        String line = editor.getDocument().getText();
                        String[] split = line.split("\n");
                        if (split.length < YmlFileEditorProvider.this.lastLine) {
                            return;
                        }
                        String content = split[YmlFileEditorProvider.this.lastLine];
                        String parent = "";
                        int spaceNum = content.replaceAll("[^ ]", "").length();
                        int tabNum = content.replaceAll("[^\\t]", "").length();
                        for (int i = currentLine - 1; i > 0; --i) {
                            String s = split[i];
                            if (!StrUtil.isNotBlank((CharSequence)s) || !s.endsWith(":")) continue;
                            int sSpaceNum = s.replaceAll("[^ ]", "").length();
                            int sTabNum = s.replaceAll("[^\\t]", "").length();
                            if (spaceNum - 1 <= sSpaceNum && tabNum <= sTabNum) continue;
                            parent = s;
                            break;
                        }
                        if (StrUtil.isNotBlank((CharSequence)content) && !content.startsWith("#")) {
                            previewEditor.getYamlEditor().getDialog().setPath(parent, content);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/wd/yamlhelper/analyzer/YmlFileEditorProvider$1", "caretPositionChanged"));
            }
        };
        YamlPersistent instance = YamlPersistent.getInstance();
        if (instance.isYamlSync()) {
            yamlEditor.getEditor().getCaretModel().addCaretListener(caretListener);
            Disposer.register((Disposable)yamlEditor, () -> yamlEditor.getEditor().getCaretModel().removeCaretListener(caretListener));
        }
        TextEditorWithPreview textEditorWithPreview = yamlEditor;
        if (textEditorWithPreview == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(4);
        }
        return textEditorWithPreview;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(5);
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(6);
        }
        if (project == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(7);
        }
        if (file == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(8);
        }
        FileEditorState fileEditorState = UIFormEditor.MY_EDITOR_STATE;
        if (fileEditorState == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(9);
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(10);
        }
        if (project == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(11);
        }
        if (targetElement == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(12);
        }
    }

    @NotNull
    public String getEditorTypeId() {
        return "YamlHelperPluginAnalyzer";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            YmlFileEditorProvider.$$$reportNull$$$0(13);
        }
        return fileEditorPolicy;
    }

    public static void saveEditorContent(Editor editor, VirtualFile file) {
        if (editor != null && file != null) {
            Document document = editor.getDocument();
            FileDocumentManager.getInstance().saveDocument(document);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/wd/yamlhelper/analyzer/YmlFileEditorProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/wd/yamlhelper/analyzer/YmlFileEditorProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: 
            case 9: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disposeEditor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 13 -> new IllegalStateException(string);
        };
    }
}

